package cn.com.duiba.creditsclub.ecosphere.sdk;


import cn.com.duiba.creditsclub.ecosphere.sdk.data.CreditsRecord;
import cn.com.duiba.creditsclub.ecosphere.sdk.data.PhoneAreaData;
import cn.com.duiba.creditsclub.ecosphere.sdk.data.SensitiveWordData;
import cn.com.duiba.creditsclub.ecosphere.sdk.data.UserBehaviorApi;
import cn.com.duiba.creditsclub.ecosphere.sdk.playway.base.UserContext;
import cn.com.duiba.creditsclub.ecosphere.sdk.template.DistributedLock;
import cn.com.duiba.creditsclub.ecosphere.sdk.utils.DuibaApi;
import cn.com.duiba.creditsclub.ecosphere.sdk.utils.Field;
import cn.com.duiba.creditsclub.ecosphere.sdk.utils.KeyValueApi;
import cn.com.duiba.creditsclub.ecosphere.sdk.utils.ProjectApi;
import cn.com.duiba.creditsclub.ecosphere.sdk.utils.QueryTable;
import cn.com.duiba.creditsclub.ecosphere.sdk.utils.RankingApi;
import cn.com.duiba.creditsclub.ecosphere.sdk.utils.UserRelationApi;

import java.util.Optional;

/**
 * 用户请求作用域内可使用的API
 *
 * @author xuhengfei
 */
public interface UserRequestApi extends Api {

    /**
     * 扣积分门票是否可用
     *
     * @param ticketNum
     * @return
     */
    boolean isCreditsTicketUsable(String ticketNum);

    /**
     * 使用扣积分门票
     *
     * @param ticketNum 票据单号
     * @return true:验证通过 false:验证失败
     */
    boolean useCreditsTicket(String ticketNum);


    /**
     * 通过门票获取扣积分详情
     *
     * @param ticketNum 票据单号
     * @return creditsRecord
     */
    Optional<CreditsRecord> getCreditsTicket(String ticketNum);

    /**
     * 获取运营配置的变量Integer
     *
     * @param key 配置项Variable
     * @return 变量对应的int值
     */
    Integer getIntVariable(String key);

    /**
     * 获取运营配置变量String
     *
     * @param key 配置项Variable
     * @return 变量对应的String值
     */
    String getStringVariable(String key);

    /**
     * 获得当前Action自动生成的记录ID
     * (预设接口内才能获取到，自定义接口中无法获取到)
     *
     * @return 记录ID
     */
    Long getCurrentRecordId();

    /**
     * 使用发奖策略出奖
     *
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    StrategyResult strategyPrize(String prizeStrategyId);

    /**
     * 使用发奖策略出奖
     * 可以指定一个用户进行策略发奖
     *
     * @param userId
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    StrategyResult sendPrizeWithStrategy(String userId, String prizeStrategyId);

    /**
     * 创建一个分布式锁对象
     *
     * @param key
     * @param expireSeconds 自动失效时间
     * @return
     */
    DistributedLock newLock(String key, int expireSeconds);

    /**
     * 获取LoggerService
     * 日志类的方法接口
     *
     * @return LoggerService
     */
    LoggerService getLoggerService();

    /**
     * 获取排行榜的服务接口
     *
     * @return
     */
    RankingApi getRankingApi();

    UserRelationApi getUserRelationApi();

    UserContext getMyUserContext();

    UserContext getUserContext(String userId);

    ProjectApi getProjectApi();

    DuibaApi getDuibaApi();

    UserBehaviorApi getUserBehaviorApi();

    /**
     * 获取一个QueryTable实例
     *
     * @param group 数据分组
     * @param clazz 映射类型
     * @param <T>
     * @return
     */
    <T extends Field> QueryTable<T> getTable(String group, Class<T> clazz);


    /**
     * 查询手机号归属地信息
     *
     * @param phone
     * @return
     */
    PhoneAreaData queryPhoneAreaData(String phone);

    /**
     * 检查是否给的字符串包含敏感词信息
     *
     * @param checkStr 需要检查的文本
     */
    SensitiveWordData checkContainSenWord(String checkStr);

    /**
     * 获取key-value存储功能API
     *
     * @return
     */
    KeyValueApi getKeyValueApi();

    /**
     * 用户积分操作API
     * @return
     */
    ConsumerCreditApi getConsumerCreditApi();

}
