package cn.com.duiba.creditsclub.ecosphere.sdk.account;


import cn.com.duiba.creditsclub.ecosphere.sdk.params.PageParams;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 账户分页查询参数
 */
public class AccPageSearchParam extends PageParams implements Serializable {
    private static final long serialVersionUID = -3737222496079397594L;
    /**
     * 兑吧用户ID
     */
    @NotNull
    private Long consumerId;
    /**
     * 业务类型
     */
    @NotNull
    private AccountTypeEnum accountType;
    /**
     * 业务涉及到的ID，可为null,默认设置为0
     */
    private Long relId = 0L;
    /**
     * 起始时间
     */
    @Nullable
    private Date startTime;
    /**
     * 截止时间
     */
    @Nullable
    private Date endTime;

    /**
     * 默认为不填
     */
    private AccountSubTypeEnum subType;

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public AccountTypeEnum getAccountType() {
        return accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public Long getRelId() {
        return relId;
    }

    public void setRelId(Long relId) {
        this.relId = relId;
    }

    @Nullable
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(@Nullable Date startTime) {
        this.startTime = startTime;
    }

    @Nullable
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(@Nullable Date endTime) {
        this.endTime = endTime;
    }

    public AccountSubTypeEnum getSubType() {
        return subType;
    }

    public void setSubType(AccountSubTypeEnum subType) {
        this.subType = subType;
    }
}
