package cn.com.duiba.creditsclub.ecosphere.sdk.data;

public enum CreditsLogChangeTypeEnum {

    SUB(1, "消耗"),
    ADD(2, "增加");

    private Integer type;
    private String desc;

    CreditsLogChangeTypeEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }


    public static CreditsLogChangeTypeEnum getByType(Integer type) {
        for (CreditsLogChangeTypeEnum typeEnum : values()) {
            if (typeEnum.getType().equals(type)) {
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
