package cn.com.duiba.creditsclub.ecosphere.sdk.data;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class SMSValidateRequestData implements Serializable {
    /**
     * 分组名称-根据业务而定 可不传
     */
    private String groupName;

    /**
     * 发送验证码手机号
     */
    private String phoneNumber;

    /**
     * 验证码长度 支持4-10位内自定义
     * 超出或小于则按照4/10生成
     */
    private int codeLength;

    /**
     * 发送内容 需要留下验证码的空位 (%s)
     * e.g.【兑吧】您参与的辽宁农行“周四掌银日”活动验证码为%s，10分钟内有效，请尽快完成验证。
     */
    private String content;


    /**
     * 验证码有效时间 默认10分钟内有效
     */
    private int expireTime = 10;

    /**
     * 验证码有效时间单位
     */
    private TimeUnit expireTimeUnit = TimeUnit.MINUTES;

    /**
     * 验证码允许重发次数 默认1分钟内只可重发一次
     */
    private int retryCount = 1;

    /**
     * 验证码允许重发时间
     */
    private int retryTime = 1;

    /**
     * 验证码允许重发时间单位
     */
    private TimeUnit retryTimeUnit = TimeUnit.MINUTES;

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public int getCodeLength() {
        return codeLength;
    }

    public void setCodeLength(int codeLength) {
        this.codeLength = codeLength;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(int expireTime) {
        this.expireTime = expireTime;
    }

    public TimeUnit getExpireTimeUnit() {
        return expireTimeUnit;
    }

    public void setExpireTimeUnit(TimeUnit expireTimeUnit) {
        this.expireTimeUnit = expireTimeUnit;
    }

    public int getRetryCount() {
        return retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryTime() {
        return retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }

    public TimeUnit getRetryTimeUnit() {
        return retryTimeUnit;
    }

    public void setRetryTimeUnit(TimeUnit retryTimeUnit) {
        this.retryTimeUnit = retryTimeUnit;
    }
}
