package cn.com.duiba.creditsclub.ecosphere.sdk.data;

import java.util.HashMap;
import java.util.Map;

public enum SendPrizeStatusEnum {

    NO_LOTTERY(0,"不开奖"),
    NO(1,"未开奖"),
    EXECUTE(2,"开奖中"),
    ERROR(3,"开奖异常"),
    YES(4,"已开奖"),
    ;

    private Integer type;
    private String desc;

    SendPrizeStatusEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }


    private static final Map<Integer, SendPrizeStatusEnum> MAP = new HashMap<>();
    static {
        for (SendPrizeStatusEnum spse: SendPrizeStatusEnum.values()) {
            MAP.put(spse.getType(), spse);
        }
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static SendPrizeStatusEnum getEnumByValue(Integer type){
        return MAP.get(type);
    }
}
