
/**
 * ---------自定义代码 参与玩法doJoin接口 demo-------------------------------------------------------
 **/
package cn.com.duiba.creditsclub.ecosphere.sdk.demo;

import cn.com.duiba.creditsclub.ecosphere.sdk.BizRuntimeException;
import cn.com.duiba.creditsclub.ecosphere.sdk.UserRequestContext;
import cn.com.duiba.creditsclub.ecosphere.sdk.playway.JoinUserRequestApi;
import cn.com.duiba.creditsclub.ecosphere.sdk.template.TemplatePresetAction;

public class JoinAction implements TemplatePresetAction<JoinUserRequestApi> {

    @Override
    public boolean accessableCheck(JoinUserRequestApi api, UserRequestContext context) {
        //验证今日参与次数是否已用完
        Integer joinLimit = api.getIntVariable("joinLimit");
        Long todayNum = api.queryMyTodayCount();
        if (todayNum >= joinLimit) {
            throw new BizRuntimeException("今日参与次数已用完");
        }
        return true;
    }

    @Override
    public boolean ticketCheck(JoinUserRequestApi api, UserRequestContext context) {
        //使用扣积分门票
        String ticketNum = context.getHttpRequest().getParameter("ticketNum");
        return api.useCreditsTicket(ticketNum);
    }

    @Override
    public Object process(JoinUserRequestApi api, UserRequestContext context) {
        //使用发奖策略发一个奖项
        return api.strategyPrize("r249d5f32");
    }

}
