package cn.com.duiba.creditsclub.ecosphere.sdk.enums;

import java.util.stream.Stream;

/**
 * @Author: daijungang
 * @Date: 2021-01-08 16:54
 * @Version: 1.0.0
 * @Describe: 积分增减类型枚举
 **/
public enum ChangeTypeEnum {
    //加积分
    ADD(1),
    //减积分
    SUB(2);
    private int type;

    ChangeTypeEnum(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }


    /**
     * 积分增减类型参数验证
     */
    public static boolean changeTypeCheck(int type) {
        return Stream.of(values()).anyMatch(s -> type == s.type);
    }
}
