package cn.com.duiba.creditsclub.ecosphere.sdk.enums;

import java.util.stream.Stream;

/**
 * @Author: daijungang
 * @Date: 2021-01-08 16:54
 * @Version: 1.0.0
 * @Describe: 业务变更类型枚举
 **/
public enum RelationTypeEnum {
    //活动
    ACTIVITY("activity"),
    //兑换
    EXCHANGE("exchange");

    private String relationType;

    RelationTypeEnum(String relationType) {
        this.relationType = relationType;
    }

    public String getRelationType() {
        return relationType;
    }

    /**
     * 业务变更类型参数验证
     */
    public static boolean relationTypeCheck(String relationType) {
        return Stream.of(values()).anyMatch(s -> relationType.equals(s.relationType));
    }
}
