package cn.com.duiba.creditsclub.ecosphere.sdk.params;

import java.util.Date;

/**
 * @Author: daijungang
 * @Date: 2021-01-08 15:38
 * @Description: 积分变更参数
 * @version: 1.0
 */
public class ConsumerCreditParam {

    /**
     * 用户id
     */
    private Long userId;
    /**
     * 积分变更数量
     */
    private long quantity;
    /**
     * 变更类型 1加积分，2减积分
     */
    private int changeType;
    /**
     * 订单号（积分日志标识号如任务编码）
     */
    private String orderNum;
    /**
     * 业务变更类型：activity-活动 exchange-兑换
     */
    private String relationType;
    /**
     * 关联活动ID或兑换商品id
     */
    private String relationId;
    /**
     * 描述
     */
    private String description;
    /**
     * 过期时间
     */
    private Date expireTime;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public long getQuantity() {
        return quantity;
    }

    public void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    public int getChangeType() {
        return changeType;
    }

    public void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }
}
