package cn.com.duiba.creditsclub.ecosphere.sdk.params;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: daijungang
 * @Date: 2021-01-08 15:38
 * @Description: 积分明细查询参数
 * @version: 1.0
 */
public class CreditLogQueryParam extends PageParams implements Serializable {

    /**
     * 用户id
     */
    private Long userId;
    /**
     * 变更类型 1加积分，2减积分
     */
    private Integer changeType;
    /**
     * 订单号（积分日志标识号如任务编码）
     */
    private String orderNum;
    /**
     * 业务变更类型：activity-活动 exchange-兑换
     */
    private String relationType;
    /**
     * 关联活动ID或兑换商品id
     */
    private String relationId;
    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
}
