package cn.com.duiba.creditsclub.ecosphere.sdk.playway.base;


import java.util.Date;
import java.util.Map;

public interface UserContext{

    String getUserId();
    /**
     * 查询我所有的道具的数量信息
     * @return key:道具id，value:拥有的道具数
     */
    Map<String,Long> getAllStageProperty();

    /**
     * 查询我的某个道具的数量
     * @param spId
     * @return
     */
    Long getStageProperty(String spId);

    /**
     * 直接发奖，不通过发奖规则进行发奖
     * @param customStrategyId
     * @param prizeId
     * @return
     */
    boolean sendPrizeWithDirect(String customStrategyId, String prizeId);

    /**
     * 记录当前用户的数据
     * @param key
     * @param value
     */
    void putUserData(String key, String value);

    void putUserDataLong(String key, long value);

    /**
     * 记录当前用户的数据
     * @param key
     * @param value
     * @param expireTime 过期时间
     */
    void putUserData(String key, String value, Date expireTime);

    void putUserDataLong(String key, long value, Date expireTime);

    /**
     * 记录当前用户的数据
     * @param key
     * @param value
     * @param expireSeconds 过期秒数
     */
    void putUserData(String key, String value, int expireSeconds);

    void putUserDataLong(String key, long value, int expireSeconds);

    /**
     * 获取当前用户的数据
     * @param key
     * @return
     */
    String getUserData(String key);

    Long getUserDataLong(String key);

}
