package cn.com.duiba.creditsclub.ecosphere.sdk.redacc;

import java.util.HashMap;
import java.util.Map;

/**
 * 提现记录状态枚举
 */
public enum AccountCashDrawStatusEnum {

    CREATE("创建", 0, "处理中"),
    DEDUCT_CONSUMER("已扣除用户账户金额", 1, "处理中"),
    //2018-10-24  此枚举含义变更:已扣除成本方金额（成本方为 兑吧账户或开发者账户）
    DEDUCT_DEVELOPER("已扣除开发者账户金额", 2, "处理中"),
    SUCCESS("提现成功", 3, "提现成功"),
    FAIL("提现失败", 4, "提现失败")
    ;

    private static final Map<Integer, AccountCashDrawStatusEnum> ALL_ENUM_MAP = new HashMap<>();
    static{
        for(AccountCashDrawStatusEnum type : values()){
            ALL_ENUM_MAP.put(type.getCode(), type);
        }
    }

    public static AccountCashDrawStatusEnum getDrawStatusEnum(Integer code) {
        return ALL_ENUM_MAP.get(code);
    }

    public static String getStatus(Integer code) {
        AccountCashDrawStatusEnum temp = ALL_ENUM_MAP.get(code);
        return temp == null ? "" : temp.getStatusDesc();
    }

    public static AccountCashDrawStatusEnum getByCode(Integer code){
        return ALL_ENUM_MAP.get(code);
    }

    AccountCashDrawStatusEnum(String desc, Integer code, String statusDesc) {
        this.code = code;
        this.desc = desc;
        this.statusDesc = statusDesc;

    }

    /** 描述 */
    private String desc;
    /** 类型码 */
    private Integer code;
    /** 状态注释 */
    private String statusDesc;

    public String getStatusDesc() {
        return statusDesc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

}
