package cn.com.duiba.creditsclub.ecosphere.sdk.timerapis;


import cn.com.duiba.creditsclub.ecosphere.sdk.TimerApi;

public interface RankingTimerApi {
    /**
     * 对排行榜TopN进行发奖
     * @param topN
     * @param callback
     */
    public void sendPrize(String type, int topN, RankingTimerCallback callback);

    /**
     * 更新排行榜分数,只支持从高到低排序
     * 排行榜中增加increase的分数
     * @param userId userId
     * @param type 排行榜type
     * @param increase 增加的分数
     */
    void updateSomebodyRankingScoreByIncr(String userId, String type, int increase);

    /**
     * 排行榜开奖出错，onfinish时调用，没有设置rankingConfig则不需要调用
     * 发奖异常 记录信息
     * @param type 排行榜type
     */
    void sendPrizeError(String type, String errorMessage);


    /**
     * 排行榜开奖成功，onfinish时调用，没有设置rankingConfig则不需要调用
     * 更新发奖状态
     * @param type 排行榜type
     */
    void sendPrizeSuccess(String type);

    public abstract class RankingTimerCallback{
        protected TimerApi api;
        public RankingTimerCallback(TimerApi api){
            this.api=api;
        }
        /**
         * 逐个处理
         * @param index
         * @param userId
         * @return prizeId 会进行回填
         */
        public abstract String doSendPrize(int index,String userId);

        /**
         * 处理结束后回调通知，本次取TopN的数据进行处理，成功出列了successCount条数据
         * @param topN
         * @param successCount
         */
        public void onFinish(int topN,int successCount){

        }
    }

    /**
     * 获取topN的排行榜数据，自定义处理
     * @param type 排行榜type
     * @param topN topN
     * @param rankingCallable rankingCallable
     */
    void doProcess(String type, int topN, RankingCallable rankingCallable);
}
