/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.creditsclub.ecosphere.sdk.utils;

import java.util.Collections;
import java.util.List;

public class PageList<T> {
    private long totalCount;
    private long totalPage;
    private List<T> list;
    private long systemTime = System.currentTimeMillis();
    public static final PageList EMPTY_PAGE = PageList.of(0L, 10L, Collections.EMPTY_LIST);

    public PageList(long totalCount, long pageSize, List<T> list) {
        this.totalCount = totalCount;
        this.list = list;
        this.totalPage = this.totalPage(pageSize);
    }

    public static <T> PageList<T> of(long totalCount, long pageSize, List<T> list) {
        return new PageList<T>(totalCount, pageSize, list);
    }

    private long totalPage(long pageSize) {
        if (this.totalCount < 1L) {
            return 0L;
        }
        return this.totalCount % pageSize == 0L ? this.totalCount / pageSize : this.totalCount / pageSize + 1L;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public List<T> getList() {
        return this.list;
    }

    public long getSystemTime() {
        return this.systemTime;
    }
}

