package cn.com.duiba.customer.link.project.custom.app1001;

import cn.com.duiba.customer.link.core.sdk.LoginUtil;
import cn.com.duiba.customer.link.core.sdk.MQUtil;
import cn.com.duiba.customer.link.project.custom.app1001.dto.NingboNoticeDTO;
import org.apache.rocketmq.client.producer.SendResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author 刘佳辉
 * @since 2022/9/14
 */
@RestController
@RequestMapping(value = "/ningbo/bank")
public class NingboBankAction {

    @Resource
    private MQUtil mqUtil;


    /**
     * 被请求示例
     * @param code
     * @return
     */
    @GetMapping("/login")
    public String login(@RequestParam("code") String code){
        return LoginUtil.getLoginUrl();
    }


    /**
     * 接收回调示例
     * mq消息发出之后，在projectx中通过监听对应tag处理业务内容
     * @param dto
     */
    @GetMapping("/task/notice")
    public void taskNotice(@RequestBody NingboNoticeDTO dto){
        // notice
        SendResult test = mqUtil.send( "test",dto.toString());
    }




}
