package cn.com.duiba.customer.link.sdk;

import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.CreditTool;
import cn.com.duiba.customer.link.sdk.project.ProjectRuntimeException;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.Map;
import java.util.TreeMap;

/**
 * 免登工具
 *
 * @author 刘佳辉
 * @since 2022/9/14
 */
@Component
@Valid
public class DuibaLoginUtil {

    @Resource
    private RemoteAppService appInfoCacheService;

    public String generateAutoLoginUrl(@NotNull HttpServletRequest request, @NotNull Long appId, @NotNull String uid, @NotNull String credits, @NotNull String dcustom, @NotNull Map<String, String> appendParams) {

        String redirectUrl = request.getParameter("dbredirect");
        Map<String, String> params = new TreeMap<>();
        params.put("uid", uid);
        params.put("credits", credits);
        params.put("dcustom", dcustom);
        params.put("redirect", AssembleTool.assembleUrl(redirectUrl, appendParams));
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            AppSimpleDto appSimpleDto = appInfoCacheService.getSimpleApp(appId).getResult();
            String serverName = request.getServerName();
            return new CreditTool(appSimpleDto.getAppKey(), appSimpleDto.getAppSecret()).buildUrlWithSign(request.getScheme() + "://" + serverName + "/autoLogin/autologin?", params);

        } catch (Exception e) {
            throw new ProjectRuntimeException("创建免登连接失败{}", e);
        }
    }

}
