package cn.com.duiba.customer.link.sdk;

import cn.com.duiba.customer.link.sdk.project.ProjectRuntimeException;
import cn.com.duiba.customer.link.sdk.project.ProjectInfoUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;

/**
 * @author 刘佳辉
 * @since 2022/9/14
 */

@Slf4j
@Component
public class MQUtil {


    public final static String TOPIC_PREFIX="customer_link_";

    @Resource
    private DefaultMQProducer rocketMqProducer;

    private SendResult send(long appId,String tag,String msg,String keys){

        Message message = new Message(
                TOPIC_PREFIX+appId,
                tag,
                msg.getBytes(StandardCharsets.UTF_8));

        // 设置代表消息的业务关键属性，请尽可能全局唯一，以方便您在无法正常收到消息情况下，可通过MQ控制台查询消息并补发
        // 注意：不设置也不会影响消息正常收发
        message.setKeys(keys);
        SendResult send;
        try {
            send = rocketMqProducer.send(message);
        }catch (Exception e){
            log.error("mq消息发送失败：{}", message, e);
            throw new ProjectRuntimeException("mq消息发送失败");
        }
        return send;

    }


    private SendResult send(long appId,String tag,String msg){
        return send(appId,tag,msg,null);
    }


    public SendResult send(String tag,String msg){
        return send(ProjectInfoUtil.getAppId(), tag, msg, null);
    }

}
