package cn.com.duiba.customer.link.sdk.http;

import cn.com.duiba.customer.link.sdk.SpringBeanFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

import java.security.KeyStore;

/**
 * HttpClient创建工具
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: HttpClientBuilder.java , v 0.1 2020-04-15 8:30 下午 ZhouFeng Exp $
 */
public class HttpClientBuilder {

    public static CloseableHttpClient createHttpClient(String beanName) {
        return createHttpClient(null, beanName);
    }

    public static CloseableHttpClient createHttpClient(KeyStore keyStore, String beanName) {
        ApplicationContext applicationContext = SpringBeanFactory.getApplicationContext();
        CloseableHttpClient httpClient;
        httpClient = getBeanWithoutException(beanName, applicationContext);
        if (httpClient != null) {
            return httpClient;
        }

        synchronized (beanName.intern()) {
            // 防止BeanDefinition被重复注册
            // 该段代码只会在第一次并发获取CloseableHttpClient时执行，且beanName数量不会太多，忽略String#intern对GC的影响
            httpClient = getBeanWithoutException(beanName, applicationContext);
            if (httpClient != null) {
                return httpClient;
            }
            // 根据每个 appId生成对应 httpClient Bean实例
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientFactoryBean.class);
            builder.addPropertyValue("keyStore", keyStore);
            builder.addPropertyValue("applicationContext", applicationContext);

            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();

            DefaultListableBeanFactory beanFactory =
                    ((DefaultListableBeanFactory) ((AbstractApplicationContext) applicationContext).getBeanFactory());

            beanFactory.registerBeanDefinition(beanName, beanDefinition);

            httpClient = (CloseableHttpClient) SpringBeanFactory.getBean(beanName);
        }
        return httpClient;
    }

    /**
     * 查询每个appId对应的 httpclient
     * @param beanName
     * @param applicationContext
     * @return
     */
    private static CloseableHttpClient getBeanWithoutException(String beanName, ApplicationContext applicationContext) {
        try {
            Object bean = applicationContext.getBean(beanName);
            return (CloseableHttpClient) bean;
        } catch (BeansException e) {
            //找不到bean，走下面的代码进行注册
        }
        return null;
    }
}
