/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.sdk.config;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(value="inner.path")
public class InnerPathConfiguration
implements InitializingBean {
    private String urlPathMapping;
    private Map<String, String> urlPathMappingMap = MapUtils.EMPTY_MAP;

    public String getUrlPathMapping() {
        return this.urlPathMapping;
    }

    public void setUrlPathMapping(String urlPathMapping) {
        this.urlPathMapping = urlPathMapping;
    }

    public Map<String, String> getUrlPathMappingMap() {
        return this.urlPathMappingMap;
    }

    public void setUrlPathMappingMap(Map<String, String> urlPathMappingMap) {
        this.urlPathMappingMap = urlPathMappingMap;
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((String)this.urlPathMapping)) {
            return;
        }
        List urlPathMappingList = JSONObject.parseArray((String)this.urlPathMapping.trim(), UrlMapping.class);
        if (CollectionUtils.isNotEmpty((Collection)urlPathMappingList)) {
            this.urlPathMappingMap = urlPathMappingList.stream().filter(urlMappingParam -> StringUtils.isNotBlank((String)urlMappingParam.getUrlPath())).collect(Collectors.toMap(UrlMapping::getUrlPath, UrlMapping::getAppName, (old, newa) -> newa));
        }
    }

    public static class UrlMapping {
        private String urlPath;
        private String appName;

        public String getUrlPath() {
            return this.urlPath;
        }

        public void setUrlPath(String urlPath) {
            this.urlPath = urlPath;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }
    }
}

