/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.sdk.http;

import cn.com.duibaboot.ext.autoconfigure.httpclient.HttpClientMethodInterceptor;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Comparator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.aopalliance.aop.Advice;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;

public class HttpClientFactoryBean
extends AbstractFactoryBean<CloseableHttpClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientFactoryBean.class);
    private KeyStore keyStore;
    private ApplicationContext applicationContext;

    protected CloseableHttpClient createInstance() {
        CloseableHttpClient pureObject = this.getPureObject();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTarget((Object)pureObject);
        ArrayList interceptors = new ArrayList(this.applicationContext.getBeansOfType(HttpClientMethodInterceptor.class).values());
        interceptors.sort(Comparator.comparingInt(Ordered::getOrder));
        for (HttpClientMethodInterceptor interceptor : interceptors) {
            proxyFactory.addAdvice((Advice)interceptor);
        }
        return (CloseableHttpClient)proxyFactory.getProxy();
    }

    protected void destroyInstance(CloseableHttpClient instance) throws Exception {
        instance.close();
    }

    private CloseableHttpClient getPureObject() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).setConnectionRequestTimeout(10).build()).setMaxConnPerRoute(100).setMaxConnTotal(5000).setUserAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36").disableAutomaticRetries().disableCookieManagement().useSystemProperties().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long time = super.getKeepAliveDuration(response, context);
                if (time == -1L) {
                    time = 30000L;
                }
                return time;
            }
        }).evictExpiredConnections();
        if (this.keyStore == null) {
            return httpClientBuilder.build();
        }
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(this.keyStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connManager).setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7dHttps\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Class<?> getObjectType() {
        return CloseableHttpClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

