/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.sdk;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.CreditTool;
import cn.com.duiba.customer.link.sdk.project.ProjectInfoUtil;
import cn.com.duiba.customer.link.sdk.project.ProjectRuntimeException;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
@Valid
public class DuibaLoginUtil {
    @Resource
    private RemoteAppService appInfoCacheService;

    public String generateAutoLoginUrl(Long appId, String uid, String credits, String dcustom, String redirect) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("uid", uid);
        params.put("credits", credits);
        params.put("dcustom", dcustom);
        params.put("redirect", redirect);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            AppSimpleDto appSimpleDto = (AppSimpleDto)this.appInfoCacheService.getSimpleApp(appId).getResult();
            if ((SpringEnvironmentUtils.isDevEnv() || SpringEnvironmentUtils.isTestEnv()) && appSimpleDto == null) {
                appSimpleDto = (AppSimpleDto)this.appInfoCacheService.getSimpleApp(Long.valueOf(1L)).getResult();
            }
            return new CreditTool(appSimpleDto.getAppKey(), appSimpleDto.getAppSecret()).buildUrlWithSign(this.getLoginRequestUrl(), params);
        }
        catch (Exception e) {
            throw new ProjectRuntimeException("\u521b\u5efa\u514d\u767b\u8fde\u63a5\u5931\u8d25{}", e);
        }
    }

    public String generateAutoLoginUrl(HttpServletRequest request, String projectId, Long appId, String uid, String credits, String dcustom, Map<String, String> appendParams) {
        String dbRedirectUrl = this.getDBRedirectUrl(projectId, request);
        return this.generateAutoLoginUrl(appId, uid, credits, dcustom, AssembleTool.assembleUrl((String)dbRedirectUrl, appendParams));
    }

    public String generateAutoLoginUrl(@NotNull String projectId, @NotNull Long appId, @NotNull String uid, @NotNull String credits, @NotNull String dcustom, @NotNull Map<String, String> appendParams) {
        return this.generateAutoLoginUrl(null, projectId, appId, uid, credits, dcustom, appendParams);
    }

    public String generateAutoLoginUrl(@NotNull String projectId, @NotNull String uid, @NotNull String credits, @NotNull String dcustom, @NotNull Map<String, String> appendParams) {
        return this.generateAutoLoginUrl(null, projectId, ProjectInfoUtil.getAppId(), uid, credits, dcustom, appendParams);
    }

    public String generateAutoLoginUrl(@NotNull String projectId, @NotNull String uid, @NotNull String dcustom, @NotNull Map<String, String> appendParams) {
        return this.generateAutoLoginUrl(null, projectId, ProjectInfoUtil.getAppId(), uid, "", dcustom, appendParams);
    }

    public String generateAutoLoginUrl(@NotNull String projectId, @NotNull String uid, @NotNull Map<String, String> appendParams) {
        return this.generateAutoLoginUrl(null, projectId, ProjectInfoUtil.getAppId(), uid, "", "", appendParams);
    }

    public String generateAutoLoginUrl(@NotNull String projectId, @NotNull String uid) {
        return this.generateAutoLoginUrl(null, projectId, ProjectInfoUtil.getAppId(), uid, "", "", new HashMap<String, String>());
    }

    private String getLoginRequestUrl() {
        if (SpringEnvironmentUtils.isDevEnv()) {
            return "https://activity.m.duibadev.com.cn/autoLogin/autologin?";
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return "https://activity.m.duibatest.com.cn/autoLogin/autologin?";
        }
        if (SpringEnvironmentUtils.isProdEnv()) {
            return "https://activity.m.duiba.com.cn/autoLogin/autologin?";
        }
        throw new RuntimeException("\u83b7\u53d6\u514d\u767b\u8bf7\u6c42\u8fde\u63a5\u9519\u8bef\uff0c\u73af\u5883\u9519\u8bef");
    }

    private String getDBRedirectUrl(String projectXId, HttpServletRequest request) {
        if (request != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getParameter("dbredirect")})) {
            return request.getParameter("dbredirect");
        }
        if (SpringEnvironmentUtils.isDevEnv()) {
            return "http://activity.m.duibadev.com.cn/projectx/" + projectXId + "/index.html";
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return "http://activity.m.duibatest.com.cn/projectx/" + projectXId + "/index.html";
        }
        if (SpringEnvironmentUtils.isProdEnv()) {
            return "http://activity.m.duiba.com.cn/projectx/" + projectXId + "/index.html";
        }
        throw new RuntimeException("\u83b7\u53d6\u514d\u767b\u8df3\u8f6c\u8fde\u63a5\u9519\u8bef\uff0c\u73af\u5883\u9519\u8bef");
    }
}

