/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.project.api.remoteservice.appisv1.utils;

import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.constants.ExpireTimeEnum;
import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.constants.IsvConfig;
import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.enums.ActStatusEnum;
import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.enums.ErrorCode;
import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.utils.IsvOptUtils;
import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.vo.IsvSharePrizeVO;
import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.vo.IsvShareVO;
import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.vo.PrizeVO;
import cn.com.duiba.projectx.sdk.BizError;
import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.StrategyResult;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.component.sendprize.dto.SendPrizeResult;
import cn.com.duiba.projectx.sdk.data.ConsumerExtra;
import cn.com.duiba.projectx.sdk.data.Option;
import cn.com.duiba.projectx.sdk.utils.ConsumerApi;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsvActivityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsvActivityUtils.class);

    public static ActStatusEnum getActStatus(UserRequestApi api) {
        Date actStartTime = IsvOptUtils.getActStartTime(api);
        Date actEndTime = IsvOptUtils.getActEndTime(api);
        Date now = new Date();
        if (now.before(actStartTime)) {
            return ActStatusEnum.NOT_START;
        }
        if (now.after(actStartTime) && now.before(actEndTime)) {
            return ActStatusEnum.START_ING;
        }
        return ActStatusEnum.END;
    }

    public static void checkActStatusThrow(UserRequestApi api) {
        ActStatusEnum actStatus = IsvActivityUtils.getActStatus(api);
        if (actStatus == ActStatusEnum.NOT_START) {
            throw new BizRuntimeException((BizError)ErrorCode.ACTIVITY_NOT_START, false);
        }
        if (actStatus == ActStatusEnum.END) {
            throw new BizRuntimeException((BizError)ErrorCode.ACTIVITY_END, false);
        }
    }

    public static PrizeVO sendPrize(UserRequestApi api, String projectName, String userId, String ruleId) {
        PrizeVO prizeVO;
        StrategyResult strategyResult = null;
        try {
            strategyResult = api.sendPrizeWithStrategy(userId, ruleId);
        }
        catch (Exception e) {
            LOGGER.error("{},\u53d1\u5956\u5f02\u5e38,userId=[{}],ruleId=[{}]", new Object[]{projectName, userId, ruleId, e});
        }
        if (strategyResult != null && strategyResult.getPrizeId() != null && strategyResult.getPrizeType() != null) {
            prizeVO = (PrizeVO)BeanUtils.copy((Object)strategyResult, PrizeVO.class);
        } else {
            prizeVO = new PrizeVO();
            prizeVO.setPrizeId("thanks");
            prizeVO.setPrizeType(IsvConfig.PRIZE_TYPE_THANKS);
            prizeVO.setOptionId("thanks");
            prizeVO.setOptionName("\u8c22\u8c22\u53c2\u4e0e");
            prizeVO.setSendCount(1L);
        }
        String prizeVOJson = JSONObject.toJSONString((Object)prizeVO);
        LOGGER.info("{},\u53d1\u5956,userId=[{}],ruleId=[{}],prize=[{}]", new Object[]{projectName, userId, ruleId, prizeVOJson});
        return prizeVO;
    }

    public static PrizeVO sendPrizeBySceneId(UserRequestApi api, String projectName, String sceneId) {
        PrizeVO prizeVO;
        SendPrizeResult strategyResult = null;
        String userId = api.getMyUserContext().getUserId();
        try {
            strategyResult = api.getProjectApi().sendPrizeBySceneId(sceneId);
        }
        catch (Exception e) {
            LOGGER.error("{},\u53d1\u5956\u5f02\u5e38,userId=[{}],ruleId=[{}]", new Object[]{projectName, userId, sceneId, e});
        }
        if (strategyResult != null && strategyResult.getPrizeId() != null && strategyResult.getPrizeType() != null) {
            prizeVO = (PrizeVO)BeanUtils.copy((Object)strategyResult, PrizeVO.class);
        } else {
            prizeVO = new PrizeVO();
            prizeVO.setRuId(strategyResult.getRuleId());
            prizeVO.setPrizeId("thanks");
            prizeVO.setPrizeType(IsvConfig.PRIZE_TYPE_THANKS);
            prizeVO.setOptionId("thanks");
            prizeVO.setOptionName("\u8c22\u8c22\u53c2\u4e0e");
            prizeVO.setSendCount(1L);
        }
        String prizeVOJson = JSONObject.toJSONString((Object)prizeVO);
        LOGGER.info("{},\u53d1\u5956,userId=[{}],ruleId=[{}],prize=[{}]", new Object[]{projectName, userId, sceneId, prizeVOJson});
        return prizeVO;
    }

    public static Option queryDirectOptionByRuId(UserRequestApi api, String ruId) {
        Option option = api.getProjectApi().queryOptions(ruId).stream().filter(t -> !Objects.equals(t.getPrizeType(), IsvConfig.PRIZE_TYPE_THANKS)).findFirst().orElseThrow(() -> new BizRuntimeException((BizError)ErrorCode.CONFIG_ERR));
        return option;
    }

    public static <T> T getParameter(UserRequestContext context, String name, Class<T> clazz) {
        String value = context.getHttpRequest().getParameter(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            if (clazz.equals(String.class)) {
                return (T)value;
            }
            if (clazz.equals(Long.class)) {
                return (T)Long.valueOf(value);
            }
            if (clazz.equals(Integer.class)) {
                return (T)Integer.valueOf(value);
            }
            if (clazz.equals(Boolean.class)) {
                return (T)Boolean.valueOf(value);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ConsumerExtra getConsumerExtra(ConsumerApi consumerApi, String userId) {
        List consumerExtraList = consumerApi.listConsumerExtraByConsumerIds((List)Lists.newArrayList((Object[])new Long[]{Long.parseLong(userId)}));
        if (CollectionUtils.isEmpty((Collection)consumerExtraList)) {
            return null;
        }
        return (ConsumerExtra)consumerExtraList.get(0);
    }

    public static ConsumerExtra getConsumerExtra(UserRequestApi api, String userId) {
        return IsvActivityUtils.getConsumerExtra(api.getDuibaApi().getConsumerApi(), userId);
    }

    public static String getJsonField(UserRequestApi api, String userId, String key) {
        ConsumerExtra consumerExtra = IsvActivityUtils.getConsumerExtra(api.getDuibaApi().getConsumerApi(), userId);
        return IsvActivityUtils.getConsumerExtraFromJson(consumerExtra, key);
    }

    public static String getConsumerExtraFromJson(ConsumerExtra consumerExtra, String key) {
        if (null == consumerExtra || StringUtils.isBlank((CharSequence)consumerExtra.getJson())) {
            return null;
        }
        try {
            return JSONObject.parseObject((String)consumerExtra.getJson()).getString(key);
        }
        catch (Exception e) {
            LOGGER.info("\u83b7\u53d6\u7528\u6237\u6269\u5c55\u4fe1\u606f\u5931\u8d25,consumerExtra:{}", (Object)JSONObject.toJSONString((Object)consumerExtra), (Object)e);
            return null;
        }
    }

    public IsvShareVO coopSharePage(UserRequestContext context, UserRequestApi api, boolean hasPrize) {
        IsvShareVO data = new IsvShareVO();
        String inviteCode = context.checkAndGetStringParameter("inviteCode");
        String inviter = api.getProjectApi().getComponentApi().getInviteAssistApi().getUserIdByInviteCode(inviteCode);
        if (StringUtils.isBlank((CharSequence)inviter)) {
            throw new BizRuntimeException((BizError)ErrorCode.INVITER_NOT_EXIST);
        }
        ConsumerExtra consumerExtra = IsvActivityUtils.getConsumerExtra(api.getDuibaApi().getConsumerApi(), inviter);
        if (Objects.nonNull(consumerExtra)) {
            data.setInviterName(consumerExtra.getNickname());
            data.setInviterIcon(consumerExtra.getAvatar());
        }
        if (hasPrize) {
            List<IsvSharePrizeVO> sharePrizeConfig = IsvOptUtils.getSharePrizeConfig(api);
            data.setPrizeList(sharePrizeConfig);
        }
        ActStatusEnum actStatus = IsvActivityUtils.getActStatus(api);
        data.setActivityStatus(actStatus.getCode());
        return data;
    }

    public static Date getExpireTime(ExpireTimeEnum unitEnum) {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        switch (unitEnum) {
            case DAY: {
                return calendar.getTime();
            }
            case WEEK: {
                if (2 == calendar.get(7)) {
                    calendar.add(5, 6);
                } else if (3 == calendar.get(7)) {
                    calendar.add(5, 5);
                } else if (4 == calendar.get(7)) {
                    calendar.add(5, 4);
                } else if (5 == calendar.get(7)) {
                    calendar.add(5, 3);
                } else if (6 == calendar.get(7)) {
                    calendar.add(5, 2);
                } else if (7 == calendar.get(7)) {
                    calendar.add(5, 1);
                }
                return calendar.getTime();
            }
            case MONTH: {
                calendar.set(5, calendar.getActualMaximum(5));
                return calendar.getTime();
            }
            case YEAR: {
                calendar.set(6, calendar.getActualMaximum(6));
                return calendar.getTime();
            }
        }
        throw new BizRuntimeException("\u65e0\u6548\u7684\u7c7b\u578b");
    }
}

