package cn.com.duiba.customer.link.project.api.remoteservice.app99349;

import cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto.*;

/**
 * @author zhangdaqing
 * @Description
 * @date 2025/9/20 15:38
 */
public interface RemoteQQService {

    /**
     * 获取用户authkey
     *
     * @param GUID   用户ID
     * @param OpenID 粉丝ID
     * @return
     */
    String getAuthKey(String GUID, String OpenID);

    /**
     * 获取用户积分扫码数据
     *
     * @param OpenID 粉丝ID
     * @param GUID
     * @return 用户参与大单购、积分扫码数据
     */
    QQScanInfoBusinessDTO getQQPNTInfo(String OpenID, String GUID);

    /**
     * 中奖订单新增
     *
     * @param request 中奖订单新增请求参数
     * @param authKey 授权码
     * @return 中奖订单新增响应
     */
    QQAwardOrderAddResponse addAwardOrder(QQAwardOrderAddRequest request, String authKey);

    /**
     * 获取用户大单购活动订单信息
     *
     * @return 大单购活动订单信息响应
     */
    QQBigBuyInfoDTO getQQBigBuyInfo(String OpenID, String GUID);

}
