package cn.com.duiba.customer.link.project.api.remoteservice.appisv1.utils;

import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.vo.IsvSharePrizeVO;
import cn.com.duiba.projectx.sdk.UserRequestApi;

import java.util.Date;
import java.util.List;

/**
 * @author lvgm
 * @date 2023/7/12
 */
public class IsvOptUtils {

    /**
     * 活动开始时间
     */
    private static final String OPT_ACT_START_TIME = "act_start_time";

    /**
     * 活动结束时间
     */
    private static final String OPT_ACT_END_TIME = "act_end_time";

    /**
     * 分享落地页奖品配置
     */
    private static final String OPT_SHARE_PRIZE_CONFIG = "share_prize_config";


    /**
     * 活动开始时间
     *
     * @param api api
     * @return Date
     */
    public static Date getActStartTime(UserRequestApi api) {
        return api.getDateVariable(OPT_ACT_START_TIME);
    }

    /**
     * 活动结束时间
     *
     * @param api api
     * @return Date
     */
    public static Date getActEndTime(UserRequestApi api) {
        return api.getDateVariable(OPT_ACT_END_TIME);
    }

    /**
     * 获取分享落地页奖品配置
     *
     * @param api api
     * @return String
     */
    public static List<IsvSharePrizeVO> getSharePrizeConfig(UserRequestApi api) {
        return api.getJsonArrayVariable(OPT_SHARE_PRIZE_CONFIG, IsvSharePrizeVO.class);
    }
}
