package cn.com.duiba.customer.link.project.api.remoteservice.app99349;

import cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto.*;

/**
 * @author zhangdaqing
 * @Description
 * @date 2025/9/20 15:38
 */
public interface RemoteQQService {

    /**
     * 获取用户authkey
     *
     * @param GUID   用户ID
     * @param OpenID 粉丝ID
     * @return
     */
    String getAuthKey(String GUID, String OpenID);

    /**
     * 获取用户积分扫码数据
     *
     * @param OpenID 粉丝ID
     * @param GUID
     * @return 用户参与大单购、积分扫码数据
     */
    QQScanInfoBusinessDTO getQQPNTInfo(String OpenID, String GUID);

    /**
     * 中奖订单新增
     *
     * @param request 中奖订单新增请求参数
     * @return 中奖订单新增响应
     */
    QQAwardOrderAddResponse addAwardOrder(QQAwardOrderAddRequest request);

    /**
     * 获取用户大单购活动订单信息
     *
     * @return 大单购活动订单信息响应
     */
    QQBigBuyInfoDTO getQQBigBuyInfo(String OpenID, String GUID);

    /**
     * 获取访问令牌
     *
     * @param unionId 用户unionId
     * @return 访问令牌
     */
    String getAccessToken(String unionId);

    /**
     * 保存宝宝信息
     *
     * @param request 宝宝信息请求
     * @return 宝宝信息保存响应
     */
   String saveBabyInfo(QQBabyInfoRequest request);

    /**
     * 查询宝宝身高全国占比
     *
     * @param request 身高占比查询请求
     * @return 身高全国占比响应
     */
    String getBabyHeightPercentile(QQBabyHeightPercentileRequest request);

    /**
     * 生成QQ星小程序太阳码
     * 服务名: QQMiniAPPService.Getwxacodeunlimit
     *
     * @param request 太阳码生成请求参数（包含scene参数）
     * @return 太阳码生成响应（包含base64编码的图片数据）
     */
    QQMiniAppCodeResponse generateMiniAppCode(QQMiniAppCodeRequest request);

}
