package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import com.alibaba.fastjson.JSONObject;

/**
 * QQ星小程序太阳码生成响应
 *
 * @author zhangdaqing
 * @date 2025/10/09
 */
public class QQMiniAppCodeResponse {

    /**
     * 返回状态码
     * Return>0: 成功
     */
    private final int Return;

    /**
     * 响应结果（JSON字符串）
     * 包含base64编码的图片数据
     */
    private final String Result;

    /**
     * 构造函数
     */
    public QQMiniAppCodeResponse(int Return, String Result) {
        this.Return = Return;
        this.Result = Result;
    }

    /**
     * Getter方法
     */
    public int getReturn() {
        return Return;
    }

    public String getResult() {
        return Result;
    }

    /**
     * 判断是否成功
     * Return > 0 表示成功
     */
    public boolean isSuccess() {
        return Return > 0;
    }

    /**
     * 获取base64编码的图片数据
     */
    public String getFiledata() {
        if (!isSuccess() || Result == null || Result.trim().isEmpty()) {
            return null;
        }

        try {
            JSONObject resultJson = JSONObject.parseObject(Result);
            return resultJson.getString("Filedata");
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 从JSON字符串创建响应对象
     */
    public static QQMiniAppCodeResponse fromJsonString(String jsonString) {
        try {
            JSONObject json = JSONObject.parseObject(jsonString);
            int returnCode = json.getIntValue("Return");
            String result = json.getString("Result");
            return new QQMiniAppCodeResponse(returnCode, result);
        } catch (Exception e) {
            throw new IllegalArgumentException("无效的响应JSON格式: " + jsonString, e);
        }
    }

    @Override
    public String toString() {
        return "QQMiniAppCodeResponse{" +
                "Return=" + Return +
                ", Result='" + (Result != null && Result.length() > 100 
                        ? Result.substring(0, 100) + "..." 
                        : Result) + '\'' +
                '}';
    }
}

