package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * QQ活动分析报表数据保存请求DTO
 * 服务代码: QQMiniAPPService.SaveActData
 *
 * @author zhangdaqing
 * @date 2025/10/11
 */
public class QQActDataSaveRequest implements Serializable {

    /**
     * 业务表名
     * 例如：积分变更、兑换记录、credits
     */
    @JsonProperty("TableName")
    @NotBlank(message = "业务表名不能为空")
    private String tableName;

    /**
     * 行数据数组（固定Key-Value格式）
     * 每行数据是一个QQTableRowData对象，包含Key和Value两个字段：
     * - Key: 存储主键ID，用于唯一标识数据
     * - Value: 存储除主键外的所有字段值，用分号(;)分隔
     * 
     * 示例：
     * [
     *   {"Key": "123", "Value": "扫码获得积分;1"},
     *   {"Key": "456", "Value": "大单购获得积分;2"}
     * ]
     */
    @JsonProperty("TableRowData")
    @NotEmpty(message = "行数据不能为空")
    private List<QQTableRowData> tableRowData;



    /**
     * 无参构造函数
     */
    public QQActDataSaveRequest() {
    }

    /**
     * 全参构造函数
     *
     * @param tableName    业务表名
     * @param tableRowData 行数据数组
     */
    public QQActDataSaveRequest(String tableName, List<QQTableRowData> tableRowData) {
        this.tableName = tableName;
        this.tableRowData = tableRowData;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<QQTableRowData> getTableRowData() {
        return tableRowData;
    }

    public void setTableRowData(List<QQTableRowData> tableRowData) {
        this.tableRowData = tableRowData;
    }


}

