package cn.com.duiba.customer.link.project.api.remoteservice.app96254.dto;

/**
 * 通用返回值vo
 *
 * @author songp
 * @date 2024/1/4 4:07 下午
 */
public class ResultDto<T> {

    /**
     * 错误码
     */
    private String code;

    /**
     * 错误消息
     */
    private String msg;

    /**
     * 时间戳
     */
    private Long timestamp;

    /**
     * 状态
     * 0:成功 -1:错误 -2:token 过期 -3:没有权限
     *
     * 状态，枚举备注
     * SUCCESS(0/成功),ERROR(-1/错误),LOGIN_TIMEOUT(-2/登录超
     * 时),PERMISSION_DENIED(-3/没有权限)
     */
    private String status;

    private T data;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static ResultDto<Void> buildFailureResp(String msg) {
        ResultDto<Void> resultDto = new ResultDto<>();
        resultDto.setStatus("-1");
        resultDto.setTimestamp(System.currentTimeMillis());
        resultDto.setMsg(msg);
        return resultDto;
    }
}
