package cn.com.duiba.customer.link.project.api.remoteservice.app96254.dto;

import java.time.LocalDateTime;

/**
 * item
 *
 * @author songp
 * @date 2024/1/10 5:20 下午
 */
public class OrderItemDto {

    /**
     * 消费门店类型code
     */
    private String shopTypeCode;

    /**
     * 渠道类型
     * YOUZAN: 有赞微商城
     * POS : 线下
     * TAOBAO : 淘宝
     * JD : 京东
     */
    private String channelType;

    /**
     * 应付金额
     */
    private Double totalFee;

    /**
     * 正常单时，代表实付金额；
     */
    private Double payment;

    /**
     * 0<=折扣率 <=1
     */
    private Double discountRate;

    /**
     * 折扣金额
     */
    private Double discountFee;

    /**
     * 扩展属性 map
     */
    private String customizedProperties;

    /**子订单ID
     *
     */
    private String orderItemId;

    /**
     * 原始子订单ID, 退单时传
     */
    private String originOrderItemId;

    /**
     * 商品Code
     */
    private String productCode;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 商品数量
     */
    private Double quantity;

    /**
     * 子订单状态
     */
    private String status;

    /**
     * 商品批次编码
     */
    private String skuId;

    /**
     * 吊牌价
     */
    private Double tagPrice;

    /**
     * 零售价
     */
    private Double retailPrice;

    /**
     * 子订单类型:正常单 - NORMAL
     */
    private String orderType;

    /**
     * 下单时间 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime orderTime;

    /**
     * 订单完成时间 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime finishTime;

    /**
     * 更新时间, 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime updateTime;

    /**
     * 数据同步时间, 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime lastSync;

    /**
     * 会员类型,固定值: qiaqia
     */
    private String memberType;

    /**
     * 会员id
     */
    private String memberId;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 消费门店名称
     */
    private String shopName;

    /**
     * 消费门店code
     */
    private String shopCode;

    /**
     * id
     */
    private String id;

    public String getShopTypeCode() {
        return shopTypeCode;
    }

    public void setShopTypeCode(String shopTypeCode) {
        this.shopTypeCode = shopTypeCode;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public Double getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(Double totalFee) {
        this.totalFee = totalFee;
    }

    public Double getPayment() {
        return payment;
    }

    public void setPayment(Double payment) {
        this.payment = payment;
    }

    public Double getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }

    public Double getDiscountFee() {
        return discountFee;
    }

    public void setDiscountFee(Double discountFee) {
        this.discountFee = discountFee;
    }

    public String getCustomizedProperties() {
        return customizedProperties;
    }

    public void setCustomizedProperties(String customizedProperties) {
        this.customizedProperties = customizedProperties;
    }

    public String getOrderItemId() {
        return orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public String getOriginOrderItemId() {
        return originOrderItemId;
    }

    public void setOriginOrderItemId(String originOrderItemId) {
        this.originOrderItemId = originOrderItemId;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Double getQuantity() {
        return quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSkuId() {
        return skuId;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }

    public Double getTagPrice() {
        return tagPrice;
    }

    public void setTagPrice(Double tagPrice) {
        this.tagPrice = tagPrice;
    }

    public Double getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(Double retailPrice) {
        this.retailPrice = retailPrice;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public LocalDateTime getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(LocalDateTime orderTime) {
        this.orderTime = orderTime;
    }

    public LocalDateTime getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(LocalDateTime finishTime) {
        this.finishTime = finishTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public LocalDateTime getLastSync() {
        return lastSync;
    }

    public void setLastSync(LocalDateTime lastSync) {
        this.lastSync = lastSync;
    }

    public String getMemberType() {
        return memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
}
