package cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto.resp;

/**
 * 微信转账回调通知解密信息
 */
public class ConfirmTransferNotifyResponse {
    /**
     * 【商户单号】商户系统内部的商家单号，在商户系统内部唯一
     */
    private String out_bill_no;
    /**
     * 【商家转账订单号】微信单号，微信商家转账系统返回的唯一标识
     */
    private String transfer_bill_no;
    /**
     * 【单据状态】商家转账订单状态
     * ACCEPTED：单据已受理
     * PROCESSING：单据处理中，转账结果尚未明确，如一直处于此状态，建议检查账户余额是否足够
     * WAIT_USER_CONFIRM：待收款用户确认，可拉起微信收款确认页面进行收款确认
     * TRANSFERING：转账中，转账结果尚未明确，可拉起微信收款确认页面再次重试确认收款
     * SUCCESS： 转账成功
     * FAIL： 转账失败
     * CANCELING： 撤销中
     * CANCELLED： 已撤销
     */
    private String state;
    /**
     * 【商户号】微信支付分配的商户号
     */
    private String mch_id;
    /**
     * 【转账金额】转账总金额，单位为“分”
     */
    private Integer transfer_amount;
    /**
     * 【收款用户OpenID】用户在商户appid下的唯一标识
     */
    private String openid;
    /**
     * 【失败原因】单已失败或者已退资金时，会返回订单失败原因
     */
    private String fail_reason;
    /**
     * 【单据创建时间】遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss.表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示北京时间2015年05月20日13点29分35秒。
     */
    private String create_time;
    /**
     * 【最后一次状态变更时间】遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss.表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示北京时间2015年05月20日13点29分35秒。
     */
    private String update_time;

    public String getOut_bill_no() {
        return out_bill_no;
    }

    public void setOut_bill_no(String out_bill_no) {
        this.out_bill_no = out_bill_no;
    }

    public String getTransfer_bill_no() {
        return transfer_bill_no;
    }

    public void setTransfer_bill_no(String transfer_bill_no) {
        this.transfer_bill_no = transfer_bill_no;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getMch_id() {
        return mch_id;
    }

    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }

    public Integer getTransfer_amount() {
        return transfer_amount;
    }

    public void setTransfer_amount(Integer transfer_amount) {
        this.transfer_amount = transfer_amount;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getFail_reason() {
        return fail_reason;
    }

    public void setFail_reason(String fail_reason) {
        this.fail_reason = fail_reason;
    }

    public String getCreate_time() {
        return create_time;
    }

    public void setCreate_time(String create_time) {
        this.create_time = create_time;
    }

    public String getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(String update_time) {
        this.update_time = update_time;
    }
}
