package cn.com.duiba.api;

import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by houwen on 2017/6/7.
 */
public class MongodbDts {

    public static final String ID = "_id";

    private String host = "http://localhost:9666";

    private String key;

    private String apiGruop = "/api/mongodb/";

    public MongodbDts(String host, String key) {
        this.host = host;
        this.key = key;
    }

    /**
     * 修改数据不存在就添加
     *
     * @param collectionName 集合名称  @see cn.com.duiba.api.MongodbCollection
     * @param data          数据对象：key：id, value: feild，value  size：<=1000
     */
    public void batchSave(String collectionName, Map<String, Map<String, String>> data) {
        String api = host + apiGruop + "batchSave";
        Map<String, String> params = new HashMap<>();
        params.put("data", JSONObject.toJSONString(data));
        params.put("collectionName", collectionName);
        params.put("sign", Sign.doSign(params, key));
        HttpClient.execute(api, params);
    }

    /**
     * 通过ID删除数据
     *
     * @param collectionName 集合名称  @see cn.com.duiba.api.MongodbCollection
     * @param id
     */
    public void remove(String collectionName, String id) {
        String api = host + apiGruop + "remove";
        Map<String, String> params = new HashMap<>();
        params.put("id", id);
        params.put("collectionName", collectionName);
        params.put("sign", Sign.doSign(params, key));
        HttpClient.execute(api, params);
    }

    /**
     * 通过ID查询数据
     *
     * @param collectionName 集合名称  @see cn.com.duiba.api.MongodbCollection
     * @param id
     * @return value
     */
    public String findById(String collectionName, String id) {
        String api = host + apiGruop + "findById";
        Map<String, String> params = new HashMap<>();
        params.put("id", id);
        params.put("collectionName", collectionName);
        params.put("sign", Sign.doSign(params, key));
        String body = HttpClient.execute(api, params);
        JSONObject json = JSONObject.parseObject(body);
        return json.getString("data");
    }

    /**
     * 批量添加数据如果ID存在就忽略
     *
     * @param collectionName 集合名称  @see cn.com.duiba.api.MongodbCollection
     * @param data          数据对象：key：id, value: feild，value  size：<=5000
     */
    public void batchInsert(String collectionName, Map<String, Map<String, String>> data) {
        String api = host + apiGruop + "batchInsert";
        Map<String, String> params = new HashMap<>();
        params.put("data", JSONObject.toJSONString(data));
        params.put("collectionName", collectionName);
        params.put("sign", Sign.doSign(params, key));
        HttpClient.execute(api, params);
    }
}
