/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.dayu.api.client;

import cn.com.duiba.dayu.api.client.HashAlgorithm;
import cn.com.duiba.dayu.api.dto.SceneConfig;
import cn.com.duiba.dayu.api.enums.ArgumentType;
import cn.com.duiba.dayu.api.enums.ConfigTypeEnum;
import cn.com.duiba.dayu.api.enums.DiversionTypeEnum;
import cn.com.duiba.dayu.api.result.DayuResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

class SceneUtils {
    private SceneUtils() {
    }

    static DayuResult resolve(SceneConfig sceneConfig, Map<ArgumentType, Object> params) {
        return SceneUtils.getDayuResult(sceneConfig, params);
    }

    private static DayuResult getDayuResult(SceneConfig sceneConfig, Map<ArgumentType, Object> params) {
        DayuResult result = new DayuResult();
        result.setArguments(new HashMap<String, String>());
        result.setExpIds(new ArrayList<Long>());
        SceneUtils.getExpIdsAndArguments(sceneConfig, null, params, result, 0);
        result.setExpIds(result.getExpIds().stream().sorted().collect(Collectors.toList()));
        return result;
    }

    private static void getExpIdsAndArguments(SceneConfig sceneConfig, String parentType, Map<ArgumentType, Object> params, DayuResult result, Integer hash) {
        if (sceneConfig == null) {
            return;
        }
        List<SceneConfig> configList = sceneConfig.getConfigList();
        if (!sceneConfig.getType().equals(ConfigTypeEnum.EXPERIMENT.getType()) && CollectionUtils.isEmpty(configList)) {
            return;
        }
        if (parentType == null) {
            configList.forEach(config -> SceneUtils.getExpIdsAndArguments(config, sceneConfig.getType(), params, result, 100));
        } else if (parentType.equals(ConfigTypeEnum.DOMAIN.getType())) {
            Integer finalHash = SceneUtils.calculateHash(params, sceneConfig.getDiversion(), sceneConfig.getName());
            configList.forEach(config -> SceneUtils.getExpIdsAndArguments(config, sceneConfig.getType(), params, result, finalHash));
        } else if (sceneConfig.getType().equals(ConfigTypeEnum.DOMAIN.getType()) && SceneUtils.doesHit(sceneConfig.getFlowRate(), hash)) {
            configList.forEach(config -> SceneUtils.getExpIdsAndArguments(config, sceneConfig.getType(), params, result, hash));
        } else if (SceneUtils.doesHit(sceneConfig.getFlowRate(), hash)) {
            Long id = sceneConfig.getId();
            result.getExpIds().add(id);
            result.getArguments().putAll(sceneConfig.getArguments());
        }
    }

    private static boolean doesHit(String flow, Integer number) {
        Integer start = Integer.parseInt(flow.split(",")[0]);
        Integer end = Integer.parseInt(flow.split(",")[1]);
        return number >= start && number <= end;
    }

    private static int calculateHash(Map<ArgumentType, Object> params, Integer hashType, String layerName) {
        int hash;
        if (hashType.equals(DiversionTypeEnum.CONSUMER_ID_HASH.getType())) {
            Long consumerId = (Long)params.get((Object)ArgumentType.CONSUMER_ID);
            hash = HashAlgorithm.dekHash(consumerId.toString() + layerName);
        } else if (hashType.equals(DiversionTypeEnum.DEVICE_ID_HASH.getType())) {
            String deviceId = (String)params.get((Object)ArgumentType.DEVICE_ID);
            hash = HashAlgorithm.apHash(deviceId + layerName);
        } else {
            hash = new Random().nextInt(100);
        }
        return (hash < 0 ? -hash : hash) % 100 + 1;
    }
}

