package cn.com.duiba.dayu.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dayu.api.dto.Layer;
import cn.com.duiba.dayu.api.dto.SceneConfig;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by lizhihui on 2017-08-09 17:21.
 */
@AdvancedFeignClient
public interface RemoteDayuABService {

    /**
     * 获取场景配置
     * 
     * @param sceneId 场景id
     * @return 场景配置
     */
    DubboResult<SceneConfig> getSceneConfig(Long sceneId);

    /**
     * 创建场景
     * 
     * @return 返回场景id
     */
    Long createScene(String name);

    /**
     * 保存配置
     *
     * @return 返回场景id
     */
    Boolean save(Long sceneId, String remark, List<Layer> layers);

    /**
     * 根据场景 id获取 layers
     * 
     * @param sceneId 场景id
     * @return layers
     */
    List<Layer> getLayers(Long sceneId);

}
