package cn.com.duiba.dayu.api.utils;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/**
 * Created by lizhihui on 2017-08-08 18:38.
 */
public class ListUtils {

    private ListUtils() {
    }

    /**
     * 将字符串(如:1,2,3,4,5)转换成List,默认分隔符为","(英文逗号)
     *
     * @param str 要转换的字符串
     * @return List<Integer>
     */
    public static List<Integer> getIntegerListByStr(String str) {
        return getIntegerListByStr(str, ",");
    }

    /**
     * 将字符串(如:1,2,3,4,5)转换成List<Integer>,分隔符自己指定
     *
     * @param str 要转换的字符串
     * @param separator 分隔符
     * @return List<Integer>
     */
    public static List<Integer> getIntegerListByStr(String str, String separator) {
        if (StringUtils.isBlank(str)) {
            return new ArrayList<>();
        }
        String[] array = str.split(separator);
        List<Integer> list = new ArrayList<>();
        for (String s : array) {
            if (StringUtils.isBlank(s.trim())) {
                continue;
            }
            list.add(Integer.parseInt(s.trim()));
        }
        return list;
    }

    /**
     * 将字符串(如:1,2,3,4,5)转换成List<Long>,默认分隔符为","(英文逗号)
     *
     * @param str 要转换的字符串
     * @return List<Long>
     */
    public static List<Long> getLongListByStr(String str) {
        return getLongListByStr(str, ",");
    }

    /**
     * 将字符串(如:1,2,3,4,5)转换成List<Long>,分隔符自己指定
     *
     * @param str 要转换的字符串
     * @param separator 分隔符
     * @return List<Long>
     */
    public static List<Long> getLongListByStr(String str, String separator) {
        if (StringUtils.isBlank(str)) {
            return new ArrayList<>();
        }
        String[] array = str.split(separator);
        List<Long> list = new ArrayList<>();
        for (String s : array) {
            if (StringUtils.isBlank(s.trim())) {
                continue;
            }
            list.add(Long.parseLong(s.trim()));
        }
        return list;
    }

    /**
     * 将字符串(如:a,b,c,d,e)转换成List<String>,默认分隔符为","(英文逗号)
     *
     * @param str 要转换的字符串
     * @return List<String>
     */
    public static List<String> getStringListByStr(String str) {
        return getStringListByStr(str, ",");
    }

    /**
     * 将字符串(如:a,b,c,d,e)转换成List<String>,分隔符自己指定
     *
     * @param str 要转换的字符串
     * @return List<String>
     */
    public static List<String> getStringListByStr(String str, String separator) {
        if (StringUtils.isBlank(str)) {
            return new ArrayList<>();
        }
        String[] array = str.split(separator);
        List<String> list = new ArrayList<>();
        for (String s : array) {
            if (StringUtils.isBlank(s.trim())) {
                continue;
            }
            list.add(s.trim());
        }
        return list;
    }

    /**
     * 将List<Integer>转换成字符串,如:1,2,3,4,5 .默认分隔符为","(英文逗号)
     *
     * @param list List<Integer>
     * @return 拼接好后的字符串
     */
    public static String getStringByIntegerList(List<Integer> list) {
        return getStringByIntegerList(list, ',');
    }

    /**
     * 将List<Long>转换成字符串,如:1,2,3,4,5 .默认分隔符为","(英文逗号)
     *
     * @param list List<Long>
     * @return 拼接好后的字符串
     */
    public static String getStringByLongList(List<Long> list) {
        return getStringByLongList(list, ',');
    }

    /**
     * 将List<Integer>转换成字符串,如:1,2,3,4,5. 自己指定分割符
     *
     * @param list List<Integer>
     * @param character 分隔符
     * @return 拼接好后的字符串
     */
    public static String getStringByIntegerList(List<Integer> list, Character character) {
        if (!CollectionUtils.isEmpty(list)) {
            StringBuilder builder = new StringBuilder();
            for (Integer integer : list) {
                builder.append(integer);
                builder.append(character);
            }
            return builder.substring(0, builder.length() - 1);
        }
        return StringUtils.EMPTY;
    }

    /**
     * 将List<Long>转换成字符串,如:1,2,3,4,5. 自己指定分割符
     *
     * @param list List<Long>
     * @param character 分隔符
     * @return 拼接好后的字符串
     */
    public static String getStringByLongList(List<Long> list, Character character) {
        if (!CollectionUtils.isEmpty(list)) {
            StringBuilder builder = new StringBuilder();
            for (Long aLong : list) {
                builder.append(aLong);
                builder.append(character);
            }
            return builder.substring(0, builder.length() - 1);
        }
        return StringUtils.EMPTY;
    }

    /**
     * 深度拷贝List
     *
     * @param src 数据源
     * @param <T> 泛型
     * @return 拷贝后的列表
     */
    public static <T> List<T> deepCopy(List<? extends Serializable> src) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(src);

        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        ObjectInputStream in = new ObjectInputStream(byteIn);
        @SuppressWarnings("unchecked")
        List<T> dest = (List<T>) in.readObject();
        return dest;
    }
}
