package cn.com.duiba.demo.center.api.enums;


/**
 * 订单状态枚举枚举
 */
public enum OrderStateTypeEnum {
    ORDERSTATE_CANCEL(1,"取消"),
    ORDERSTATE_NO(2,"待发货"),
    ORDERSTATE_YES(3,"已发货");

    private Integer type;
    private String desc;

    OrderStateTypeEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }

    /**
     * 通过类型获取枚举信息
     * @param type
     * @return
     */
    public static OrderStateTypeEnum getByType(Integer type){
        for(OrderStateTypeEnum typeEnum : values()){
            if(typeEnum.getType().equals(type)){
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}

