package cn.com.duiba.developer.center.api.instruction;

import cn.com.duiba.developer.center.api.domain.dataobject.DeveloperDO;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import org.apache.commons.beanutils.BeanUtils;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

/**
 * Created by liuyao on 16/7/22.
 * 查询指示器
 */
public class AbstructInstruction<T> implements Serializable {
    private static final long serialVersionUID = 4331310203748454471L;

    private List<String> propertyNameList = Lists.newArrayList();
    private Class<T> clazz;
    {
        this.clazz=(Class<T>)getSuperClassGenricType(getClass(), 0);
    }

    public void addProperty(String propertyName){
        propertyNameList.add(propertyName);
    }

    public T transform(T object) {
        try {
            T obj = clazz.newInstance();
            for(String propertyName : propertyNameList){
                Object value = BeanUtils.getProperty(object,propertyName);
                BeanUtils.setProperty(obj,propertyName,value);
            }
            return obj;
        }catch(Exception e){
            throw new RuntimeException(e);
        }

    }

    public static Class<Object> getSuperClassGenricType(final Class clazz, final int index) {

        //返回表示此 Class 所表示的实体（类、接口、基本类型或 void）的直接超类的 Type。
        Type genType = clazz.getGenericSuperclass();

        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        //返回表示此类型实际类型参数的 Type 对象的数组。
        Type[] params = ((ParameterizedType) genType).getActualTypeArguments();

        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }

        return (Class) params[index];
    }
}
