package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.Instruction.AppGroupInstruction;
import cn.com.duiba.developer.center.api.domain.dto.*;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 16/7/29.
 */
public interface RemoteAppService {
    /**
     * 创建App,注册时请不要调此服务,因为注册服务会自动完成app的创建
     * @param param
     * @return
     */
    public DubboResult<Long> CreateApp(CreateAppQueryParams param);

    /**
     * 获取App简单字段(可高并发)
     * @param id
     * @return
     */
    public DubboResult<AppSimpleDto> getSimpleApp(Long id);

    /**
     * 在instruction中说明你想要的App子集对象
     * @param instruction
     * @return
     */
    public DubboResult<AppGroupDto> getAppGroup(Long appId,AppGroupInstruction instruction);

    /**
     * 更新应用配置信息
     * @param params
     * @return
     */
    public DubboResult<Boolean> appInfo(AppInfoFromParams params);

    /**
     * app接口配置
     * @param urlDto
     * @return
     */
    public DubboResult<Boolean> apiConfig(AppUrlDto urlDto);

    /**
     * app预算配置
     * @param appBudget
     * @return
     */
    public DubboResult<Boolean> budgetConfig(AppBudgetDto appBudget);

    public DubboResult<Boolean> doSendSecret(Long appId);

}
