package cn.com.duiba.developer.center.api.domain.paramquery;

import org.apache.commons.lang.StringUtils;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Created by liuyao on 16/8/3.
 */
public class AppInfoFromParams implements Serializable {
    private static final long serialVersionUID = -651032424286750990L;
    @NotNull
    private Long appId;
    @NotNull
    @Min(value=1,message = "积分汇率必须为正整数")
    private Integer creditsRate;
    @NotNull(message="应用名称不能为空")
    private String appName;
    @NotNull
    private String appTitle;
    @NotNull
    private String logo;
    @NotNull
    private String unitName;
    @NotNull
    private String category1;
    private String category2;
    @NotNull
    private String earnCreditsUrl;
    @NotNull
    private Boolean creditsDecimalPoint;
    @NotNull
    private Boolean creditsType;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getCreditsRate() {
        return creditsRate;
    }

    public void setCreditsRate(Integer creditsRate) {
        this.creditsRate = creditsRate;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppTitle() {
        return appTitle;
    }

    public void setAppTitle(String appTitle) {
        this.appTitle = appTitle;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getCategory1() {
        return category1;
    }

    public void setCategory1(String category1) {
        this.category1 = category1;
    }

    public String getCategory2() {
        return category2;
    }

    public void setCategory2(String category2) {
        this.category2 = category2;
    }

    public String getEarnCreditsUrl() {
        return earnCreditsUrl;
    }

    public void setEarnCreditsUrl(String earnCreditsUrl) {
        this.earnCreditsUrl = earnCreditsUrl;
    }

    public Boolean getCreditsDecimalPoint() {
        return creditsDecimalPoint;
    }

    public void setCreditsDecimalPoint(Boolean creditsDecimalPoint) {
        this.creditsDecimalPoint = creditsDecimalPoint;
    }

    public Boolean getCreditsType() {
        return creditsType;
    }

    public void setCreditsType(Boolean creditsType) {
        this.creditsType = creditsType;
    }
}
