package cn.com.duiba.developer.center.api.domain.paramquery;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import org.apache.commons.lang.StringUtils;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * Created by liuyao on 16/7/29.
 */
public class CreateAppQueryParams implements Serializable{
    private static final long serialVersionUID = -7512381957793791622L;

    @NotNull(message = "创建App必须指定开发者")
    private Long developerId;
    @NotNull(message = "App名称不能为空")
    private String name;
    @NotNull(message = "积分汇率不能为空")
    @Min(value = 1,message = "积分汇率必须大于0")
    private Integer creditsRate = 100;
    @NotNull(message = "积分名称不能为空")
    private String unitName;
    @NotNull(message = "必须指定应用类别")
    private String category;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCreditsRate() {
        return creditsRate;
    }

    public void setCreditsRate(Integer creditsRate) {
        this.creditsRate = creditsRate;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public List<String> getCategory(){
        if(StringUtils.isBlank(category)){
            return Collections.emptyList();
        }
        Splitter spl = Splitter.on(",").limit(2).trimResults().omitEmptyStrings();
        return spl.splitToList(category);
    }

    public void setCategory(String ...category) {
        if(category.length>2){
            throw new RuntimeException("应用类别层级最多为两级");
        }
        Joiner joiner = Joiner.on(",").skipNulls();
        this.category = joiner.join(category);
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

}
