/**
 * duiba-developer AmbDeveloperWithdrawCashAuditDAO.java
 * 
 * File Created at 2015年12月24日 下午8:02:43
 * $Id$
 *
 * Copyright 2015 duiba.com Croporation Limited.
 * All rights reserved.
 */
package cn.com.duiba.developer.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashAuditDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 *
 * @create 2015年12月24日 下午8:02:43
 * @author Hermit
 * @version
 */
public interface RemoteAmbDeveloperWithdrawCashAuditService {
    /**
     * 新增审核信息
     * @param ambDeveloperWithdrawCashAuditDto
     */
    public DubboResult<AmbDeveloperWithdrawCashAuditDto> insert(AmbDeveloperWithdrawCashAuditDto ambDeveloperWithdrawCashAuditDto);
    
    /**
     * 根据ID查询
     * @param id
     * @return
     */
    public DubboResult<AmbDeveloperWithdrawCashAuditDto> findById(Long id);
    
    /**
     * 获取有效的审核通过的审核信息
     * @param developerId 
     * @param cashType 提现类型
     * @return
     */
    public DubboResult<AmbDeveloperWithdrawCashAuditDto> findValidPassAudit(Long developerId, String cashType);
    
    /**
     * 获取正在审核的信息
     * @param developerId
     * @return
     */
    public DubboResult<AmbDeveloperWithdrawCashAuditDto> findAuditing(Long developerId, String cashType);
    
    /**
     * 禁用所有效的审核
     * @param developerId
     * @param cashType
     */
    public void disableValidPassAudit(Long developerId, String cashType);
    
    /**
     * 将审核材料的状态由创建更新为待审核
     * @param auditId
     * @return
     */
    public int updateStatusCreateToWait(Long auditId);

    /**
     * @param auditIds
     */
    public DubboResult<List<AmbDeveloperWithdrawCashAuditDto>> findByIds(List<Long> auditIds);
    
}
