package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.DlpIncomeDetailDto;
import cn.com.duiba.developer.center.api.domain.dto.ManualChargeApplyDto;
import cn.com.duiba.developer.center.api.domain.dto.RechargeOrdersDto;
import cn.com.duiba.developer.center.api.domain.dto.RemainingMoneyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 16/7/25.
 */
public interface RemoteDeveloperAccountService {

    public DubboResult<RemainingMoneyDto> findRemainingMoney(Long developerId);

    public DubboResult<DlpIncomeDetailDto> findIncomeDetail(Long developerId);
    /**
     * 查询在线充值订单
     * @author zhengjy
     * @param 
     * @return
     */
    public DubboResult<RechargeOrdersDto> findRechargeOrder(Long orderId);
    /**
     * 在线充值插入充值订单表
     * @author zhengjy
     * @param 
     * @return
     */
    public DubboResult<Long> addRechargeOrder(RechargeOrdersDto order);
    /**
     * 在线充值更新充值订单表
     * @author zhengjy
     * @param 
     * @return
     */
    public DubboResult<Long> updateRechargeOrder(RechargeOrdersDto order);
    /**
     * 查询开发者剩余额
     * @author zhengjy
     * @param 
     * @return
     */
    public DubboResult<RemainingMoneyDto> findDeveloperRemainingMoney(Long developerId);
    
    /**
     * 支付费用详情插入
     * @param manualChargeApplyDto
     * @return
     */
    DubboResult<Long> saveManualChargeApply(ManualChargeApplyDto manualChargeApplyDto);
    /**
     * 支付费用详情更新
     * @param 
     * @return
     */
    DubboResult<Long> updateManualChargeApply(ManualChargeApplyDto manualChargeApplyDto);
}
