package cn.com.duiba.developer.center.api.Instruction;

import cn.com.duiba.developer.center.api.domain.dto.*;
import com.google.common.collect.Sets;

import java.io.Serializable;
import java.util.Set;

/**
 * Created by liuyao on 16/8/2.
 * app子集组获取指示器
 */
public class AppGroupInstruction implements Serializable {
    private Set<Class> clazzSet = Sets.newHashSet();

    public void needSimple(){clazzSet.add(AppSimpleDto.class);}
    /**
     * 我想要跟app有关的URL集合对象
     */
    public void needUrl(){
        clazzSet.add(AppUrlDto.class);
    }
    /**
     * 我想要app的预算对象
     */
    public void needBudget(){
        clazzSet.add(AppBudgetDto.class);
    }
    /**
     * 我想要app不常用的子集对象
     */
    public void needOther(){
        clazzSet.add(AppOtherDto.class);
    }
    /**
     * 我想要app首页布局对象
     */
    public void needLayout(){
        clazzSet.add(AppLayoutDto.class);
    }

    public Set<Class> getClassSet(){
        return this.clazzSet;
    }
}
