package cn.com.duiba.developer.center.api.domain.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by liuyao on 16/7/28.
 */
public class AppSimpleDto implements Serializable {
    private static final long serialVersionUID = -2727327703409654191L;

    public static final int BoundAlipay = 0; // 支付宝账号绑定
    public static final int BoundQQ = 1; // QB号码绑定
    public static final int BoundPhone = 2; // 手机号码绑定
    public static final int SwitchOpenVipLimit = 3; // 是否开启会员限制
    public static final int SwitchOpenShare = 4;	// 是否开启分享功能
    public static final int SwitchCodeEdit = 5;//是否开启代码编辑
    public static final int SwitchCloseClientAlarm = 6;//是否关闭客户端未使用源码警示
    public static final int SwitchCloseAppTradingLimit = 7;//是否开启APP交易限制
    public static final int SwitchCreditsDecimalPoint  = 8;//是否开启提供人民币格式展示
    public static final int SwitchShowcasePlace1 = 9;	// 橱窗位1
    public static final int SwitchShowcasePlace2 = 10;	// 橱窗位2
    public static final int SwitchShowcasePlace3 = 11;	// 橱窗位3
    public static final int SwitchCloseCreditsType  = 12;//是否开启积分模式
    public static final int SwitchUseLoginCode  = 13;//是否开启定制唤起登录
    public static final int SwitchFreeItemVip = 14;//开启兑吧免费商品设置会员等级
    public static final int SwitchExchangeCreditsType = 16;//可编辑抽奖积分
    public static final int SwitchOpenBulletin = 15;//开启首页公示条
    public static final int SwitchPlatformCouponType = 17;//开启或关闭券库
    public static final int SwitchMallCreditsType = 18;//是否开启无积分商城模式,0否,1是

    private Long id;
    private Long developerId;//开发者Id
    private String name;//app名称
    private String title;
    private String appKey;//应用唯一标识
    private Integer creditsRate;// 积分兑换金钱的比例 1元对应多少个积分
    private Boolean enable;
    private String unitName; // 自定义积分单位名称（默认为‘积分’）
    private Date newItemTime;//最新查看兑吧商品时间
    private Integer showItemNum; // 最多展示的兑换项数量 目前分为三档 15 20 25个 默认展示20个

    private Boolean autoRecommend;
    private Integer appSwitch;

    private String appSecret;//通常不会注入,调用RemoteAppService.getSimpleApp获取的对象可得到此变量

    private Date gmtCreate;
    private Date gmtModified;

    public boolean isAppSwitch(int boundType) {
        int v = 1 << boundType;
        int ret = appSwitch & v;
        return ret != 0;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Integer getCreditsRate() {
        return creditsRate;
    }

    public void setCreditsRate(Integer creditsRate) {
        this.creditsRate = creditsRate;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Date getNewItemTime() {
        return newItemTime;
    }

    public void setNewItemTime(Date newItemTime) {
        this.newItemTime = newItemTime;
    }

    public Integer getShowItemNum() {
        return showItemNum;
    }

    public void setShowItemNum(Integer showItemNum) {
        this.showItemNum = showItemNum;
    }

    public Boolean getAutoRecommend() {
        return autoRecommend;
    }

    public void setAutoRecommend(Boolean autoRecommend) {
        this.autoRecommend = autoRecommend;
    }

    public Integer getAppSwitch() {
        return appSwitch;
    }

    public void setAppSwitch(Integer appSwitch) {
        this.appSwitch = appSwitch;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

}
