package cn.com.duiba.developer.center.api.domain.dto;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * Created by suyuanlong on 16/8/11.
 */
public class CreditsFloorSkinDto implements Serializable {
    private static final long serialVersionUID = -9155105380257314868L;

    public static final String GET_CACHE_KEY="MAX_CREDITS_FLOOR_SKIN_";

    private Long id;
    @NotNull
    @Size(max=8)
    private String skinName;
    @NotNull
    private String skinList;
    @NotNull
    private String skinCss;
    @NotNull
    private String skinJs;
    @NotNull
    private String skinXhtml;
    private Short status;// 0: 隐藏  1：显示
    private Boolean specify;// 0: 非定向  1：定向
    @NotNull
    private  Long adminId;

    private Date gmtCreate;

    private Date gmtModified;



    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSkinCss() {
        return skinCss;
    }

    public void setSkinCss(String skinCss) {
        this.skinCss = skinCss;
    }

    public String getSkinJs() {
        return skinJs;
    }

    public void setSkinJs(String skinJs) {
        this.skinJs = skinJs;
    }

    public String getSkinList() {
        return skinList;
    }

    public void setSkinList(String skinList) {
        this.skinList = skinList;
    }

    public String getSkinName() {
        return skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public String getSkinXhtml() {
        return skinXhtml;
    }

    public void setSkinXhtml(String skinXhtml) {
        this.skinXhtml = skinXhtml;
    }

    public Boolean getSpecify() {
        return specify;
    }

    public void setSpecify(Boolean specify) {
        this.specify = specify;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }
    public Long getAdminId() {
        return adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public boolean check() {
        if (null == skinList || skinCss == null || skinJs == null || null == skinXhtml) {
            return false;
        }
        return true;

    }

    public String getCacheKey() {
        return CreditsFloorSkinDto.GET_CACHE_KEY + this.id;
    }
}
