/**
 * Project Name:developer-center-api File Name:SubPageTargetEnum.java Package
 * Name:cn.com.duiba.developer.center.api.domain.enums Date:2016年8月19日下午4:29:49 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:SubPageTargetEnum <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年8月19日 下午4:29:49 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum SubPageTargetEnum implements EnumInterface {
    GO_TO_SUB_PAGE("subPage", "点击后跳转到子页面"),

    GO_TO_DETAIL("detail", "点击后跳转到详情页面");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private SubPageTargetEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SubPageTargetEnum getByCode(String code) {
        for (SubPageTargetEnum enumVal : SubPageTargetEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
