package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutBrickDto;
import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.api.domain.dto.FloorConfigDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 16/7/27.
 */
public interface RemoteAppLayoutService {

    public DubboResult<PaginationVO<AppLayoutBrickDto>> getSystemLayoutPage(PageQueryEntity params);

    public DubboResult<PaginationVO<AppLayoutBrickDto>> getCustomLayoutPage(PageQueryEntity params);

    DubboResult<AppLayoutDto> selectAppLayoutLackByAppId(Long appId);

    DubboResult<String> selectDevelopSortJsonByAppId(Long appId);

    DubboResult<String> selectDevelopDataShowJsonByAppId(Long appId);

    DubboResult<Integer> updateDevelopSortJsonByAppId(Long appId, String json);

    /**
     * 根据appId和floorId查询楼层配置
     *
     * @author zhanglihui
     * @param appId   app主键
     * @param floorId 楼层ID
     * @return
     */
    DubboResult<FloorConfigDto> selectDevFloorConfigByAppId(Long appId, Long floorId);

    /**
     * 根据appId和floorId更新楼层配置
     * 如果楼层配置不存在，则把配置信息写入到developDataShowJson中；如果楼层配置存在，则更新developDataShowJson中的配置信息
     *
     * @author zhanglihui
     * @param appId       app主键
     * @param floorId     楼层ID
     * @param floorConfig 楼层配置
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateDevFloorConfigByAppId(Long appId, Long floorId, FloorConfigDto floorConfig);

}
