package cn.com.duiba.developer.center.api.domain.dto;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * Created by suyuanlong on 16/8/11.
 */
public class CreditsFloorSkinDto implements Serializable {
    private static final long serialVersionUID = -9155105380257314868L;

    public static final String GET_CACHE_KEY="MAX_CREDITS_FLOOR_SKIN_";

    private Long id;
    @NotNull
    @Size(max=20)
    private String skinName;
    @NotNull
    private String skinImage;
    @NotNull
    private String skinList;
    @NotNull
    private String skinCss;
    @NotNull
    private String skinJs;
    @NotNull
    private String skinXhtml;
    private Short status;// 0: 隐藏  1：显示
    private Boolean specify;// 0: 非定向  1：定向
    @NotNull
    private  Long adminId;

    private Date gmtCreate;

    private Date gmtModified;

    public Map<Long,Integer> getTypeMap(){
        Map<Long,Integer> typeMap = Maps.newHashMap();
        JSONArray skinList = JSONArray.parseArray(getSkinList());
        for (int i = 0; i < skinList.size(); i++) {
            JSONObject json = skinList.getJSONObject(i);
            typeMap.put(json.getLong("id"),json.getInteger("type"));
        }
        return typeMap;
    }


    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSkinCss() {
        return skinCss;
    }

    public void setSkinCss(String skinCss) {
        this.skinCss = skinCss;
    }

    public String getSkinJs() {
        return skinJs;
    }

    public void setSkinJs(String skinJs) {
        this.skinJs = skinJs;
    }

    /**
     * @return jsonString:
     * [
     *     {id:楼层Id,name:楼层名称,md5:当前楼层真实的MD5,type:楼层类型,pageId:如果是子页面类型,子页面Id},
     *     {...},
     * ]
     */
    public String getSkinList() {
        return skinList;
    }

    public void setSkinList(String skinList) {
        this.skinList = skinList;
    }

    public String getSkinName() {
        return skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public String getSkinXhtml() {
        return skinXhtml;
    }

    public void setSkinXhtml(String skinXhtml) {
        this.skinXhtml = skinXhtml;
    }

    public Boolean getSpecify() {
        return specify;
    }

    public void setSpecify(Boolean specify) {
        this.specify = specify;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }
    public Long getAdminId() {
        return adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public String getSkinImage() {
        return skinImage;
    }

    public void setSkinImage(String skinImage) {
        this.skinImage = skinImage;
    }

    public boolean check() {
        if (null == skinList || skinCss == null || skinJs == null || null == skinXhtml) {
            return false;
        }
        return true;

    }

    public String getCacheKey() {
        return CreditsFloorSkinDto.GET_CACHE_KEY + this.id;
    }
}
