package cn.com.duiba.developer.center.api.domain.dto;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import cn.com.duiba.developer.center.api.domain.BaseDO;
import cn.com.duiba.developer.center.api.domain.enums.ItemActivityExtEnum;

import com.alibaba.fastjson.JSON;

/**
 * 兑吧活动扩展Dto
 *<br/>
 * Author：zhengjy <br/>
 * Create Time：2016年11月8日 下午7:49:46
 */
public class ItemActivityExtDto extends BaseDO{
	private static final long serialVersionUID = -247230658673450611L;
	private Long id;
	private Long sourceId;//兑吧活动id
	private String sourceType;//兑吧活动类型
	private String extParam;//扩展字段
	private Date gmtModified;
	private Date gmtCreated;
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getSourceId() {
		return sourceId;
	}
	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}
	
	public String getExtParam() {
		return extParam;
	}
	public void setExtParam(String extParam) {
		this.extParam = extParam;
	}
	public String getSourceType() {
		return sourceType;
	}
	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}
	public Date getGmtModified() {
		return gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}
	public Date getGmtCreated() {
		return gmtCreated;
	}
	public void setGmtCreated(Date gmtCreated) {
		this.gmtCreated = gmtCreated;
	}
	public Map<String,String> getExePramObj() {
		if(StringUtils.isBlank(this.extParam)){
			return new HashMap<String,String>();
		}
		return (Map<String, String>) JSON.parseObject(this.extParam, new HashMap<String,String>().getClass());
	}
	public void setExeParamObj(Map<String,String> map){
		if(map ==null || map.isEmpty()){
			return;
		}
		this.extParam = null;
		this.extParam =com.alibaba.fastjson.JSONObject.toJSONString(map);
	}
	

}

