/**
 * Project Name:developer-center-api
 * File Name:AppPushStatusEnum.java
 * Package Name:cn.com.duiba.developer.center.api.domain.enums
 * Date:2016年11月2日下午9:51:11
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;

/**
 * APP计划任务执行状态枚举<br/>
 * Date:     2016年11月2日 下午9:51:11 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public enum AppPushStatusEnum implements EnumInterface {
    INIT("INIT", "初始化"),
    
    TO_EXEC("TO_EXEC", "待执行"),
    
    SUCC("SUCC", "执行成功"),
    
    FAILED("FAILED", "执行失败");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private AppPushStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AppPushStatusEnum getByCode(String code) {
        for (AppPushStatusEnum enumVal : AppPushStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}

