/**
 * Project Name:developer-center-api File Name:ShowcaseRelationTypeEnum.java Package
 * Name:cn.com.duiba.developer.center.api.domain.enums Date:2016年10月14日下午2:52:57 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;

import com.google.common.base.Objects;

/**
 * 橱窗位配置内容类型 
 * 
 * Date: 2016年10月14日 下午2:52:57 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum ShowcaseRelationTypeEnum implements EnumInterface {

    /** 兑吧商品 */
    ITEM("item", null, "兑吧商品"),

    /** 开发者自有商品 */
    APP_ITEM("app_item", null, "自有商品"),
    
    /** 兑吧专题活动 */
    DUIBA_ACTIVITY("duibaActivity", 0, "专题活动"),
    
    /** 老版大转盘，管理后台已关闭上架入口，开发者端还会用到 */
    OLD_TURNTABLE("oldTurntable", 1, "大转盘"),

    /** 幸运大转盘 */
    TURNTABLE("turntable", 4, "幸运大转盘"),

    /** 兑吧单品抽奖 */
    SINGLE_LOTTERY("duibaSingleLottery", 2, "单品抽奖"),
    
    /* ==============APP自有活动============== */
    /** 自有单品抽奖 */
    APP_SINGLE_LOTTERY("appSingleLottery", 3, "单品抽奖"),
    
    /** 手动开奖 */
    APP_MANUAL_LOTTERY("appManualLottery", 5, "手动开奖"),

    /* ==============活动工具============== */
    /** 活动工具-摇奖机 */
    TOOL_TIGER("tiger", 9, "摇奖机"),

    /** 活动工具-刮刮乐 */
    TOOL_SCRATCH_CARD("scratchCard", 7, "刮刮乐"),

    /** 活动工具-摇一摇 */
    TOOL_SHAKE("shake", 6, "摇一摇"),

    /** 活动工具-大转盘 */
    TOOL_TURNTABLE("turntableNew", 8, "大转盘"),

    /** 活动工具-翻牌子 */
    TOOL_FLOP("flop", 11, "翻牌子"),

    /** 活动工具-砸彩蛋 */
    TOOL_SMASHG("smashg", 12, "砸彩蛋"),

    /* ==============老游戏活动============== */
    /** 圣诞老人 */
    GAME_SANTA("santa", 20, "圣诞老人"),

    /** 数年终奖 */
    GAME_YEAR_AWARD("yearAward", 21, "数年终奖"),

    /** 女神PK */
    GAME_GIRL("girl", 22, "女神PK"),

    /** 人在囧途 */
    GAME_JIONG("jiong", 23, "人在囧途"),

    /* ==============新游戏活动============== */
    /** 兑吧游戏 */
    NEW_GAME("ngame", 28, "游戏"),

    /** 答题 */
    QUESTION("question", 40, "答题"),

    /** 测试题 */
    QUIZZ("quizz", 41, "测试题"),

    /** 兑吧竞猜 */
    GUESS("guess", 42, "竞猜"),
    
    /** 秒杀活动 */
    DUIBA_SECKILL("seckill", 31, "秒杀活动"),
    
    /** 秒杀专题 */
    SECONDS_KILL_ACTIVITY("secondsKillActivity", 30, "秒杀专题"),
    
    /** 积分游戏 */
    CREDIT_GAME("creditGame", 46, "积分游戏"),
    
    /** 小游戏 */
    LITTLE_GAME("littleGame", 47, "小游戏");

    /** 代码 */
    private String  code;

    /** 活动类型，对应operating_activity.type */
    private Integer operatingActivityType;

    /** 描述 */
    private String  desc;

    private ShowcaseRelationTypeEnum(String code, Integer operatingActivityType, String desc) {
        this.code = code;
        this.operatingActivityType = operatingActivityType;
        this.desc = desc;
    }

    public static ShowcaseRelationTypeEnum getByCode(String code) {
        for (ShowcaseRelationTypeEnum enumVal : ShowcaseRelationTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public static ShowcaseRelationTypeEnum getByType(Integer operatingActivityType) {
        for (ShowcaseRelationTypeEnum enumVal : ShowcaseRelationTypeEnum.values()) {
            if (enumVal.getOperatingActivityType() != null
                && Objects.equal(operatingActivityType, enumVal.getOperatingActivityType())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    public Integer getOperatingActivityType() {
        return operatingActivityType;
    }
}
